//
//  ContentView.swift
//  Handy Harp Client
//  
//  Created by KIRA Ryouta on 2025/11/15.
//
/*
 MIT License

 Copyright (c) 2025 PROCYON STUDIO CO., LTD.
 Copyright (c) 2025 KIRA Ryouta

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

import SwiftUI

struct AboutView: View {
    var body: some View {
        VStack {
            Image(nsImage:NSApplication.shared.applicationIconImage!)
            Text("Hand Harp II Client")
                .font(Font.title)
                .padding(.vertical, 4)
            Text("Version \(Bundle.main.object(forInfoDictionaryKey: "CFBundleShortVersionString") as! String)")
                .padding(.bottom, 4)
            Text("©︎ 2025 PROCYON STUDIO CO., LTD.")
                .padding(.bottom, 4)
            Text("©︎ 2025 KIRA Ryouta")
                .padding(.bottom, 8)
            Button("Quit Handy Harp II Client") {
                NSApplication.shared.terminate(nil)
            }
        }
        .padding()
        .frame(minWidth: 300, maxWidth: 300)
    }
}

#Preview {
    AboutView()
}
